/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPropertyPage.h,v 1.3 1999/12/22 10:05:04 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPropertyPage_h	// [
#define Included_CPropertyPage_h

#include "pgpClassesConfig.h"
#include <prsht.h>

#include "CDialog.h"
#include "CList.h"

_PGP_BEGIN

// Class CPropertyPage

class CPropertyPage : public CDialog
{
	friend class CPropertySheet;

public:
	CPropertyPage() : mPageHandle(NULL), mPError(NULL), mPSkipConfirmCancel(NULL) { }
	~CPropertyPage() { }

	operator HPROPSHEETPAGE() const {return mPageHandle;}
	HPROPSHEETPAGE PageHandle() const {return mPageHandle;}

	PGPBoolean	IsCreated() const {return IsntNull(mPageHandle);}

	PGPBoolean	Apply() const
	{
		return static_cast<PGPBoolean>(
			CWindow(GetParent()).SendMessage(PSM_APPLY));
	}

	void		Changed(HWND pageHandle) const
	{
		CWindow(GetParent()).SendMessage(PSM_CHANGED, 
			reinterpret_cast<LPARAM>(pageHandle));
	}

	void		Close() const
	{
		CWindow(GetParent()).SendMessage(PSM_CANCELTOCLOSE);
	}

	HWND		GetTabControl() const
	{
		return reinterpret_cast<HWND>(
			CWindow(GetParent()).SendMessage(PSM_GETTABCONTROL));
	}

	void		PressButton(PGPInt32 button) const
	{
		CWindow(GetParent()).PostMessage(PSM_PRESSBUTTON, button);
	}

	PGPBoolean	SetCurSel(PGPInt32 index) const
	{
		return static_cast<PGPBoolean>(
			CWindow(GetParent()).SendMessage(PSM_SETCURSEL, index));
	}

	PGPBoolean	SetCurSel(HPROPSHEETPAGE page) const
	{
		return static_cast<PGPBoolean>(
			CWindow(GetParent()).SendMessage(PSM_SETCURSEL, 0, 
			reinterpret_cast<LPARAM>(page)));
	}

	void		SetFinishText(const char *text) const
	{
		CWindow(GetParent()).SendMessage(PSM_SETFINISHTEXT, 0, 
			reinterpret_cast<LPARAM>(text));
	}

	void		SetTitle(PGPUInt32 style, const char *title) const
	{
		CWindow(GetParent()).SendMessage(PSM_SETTITLE, style, 
			reinterpret_cast<LPARAM>(title));
	}

	void		SetWizButtons(PGPUInt32 flags) const
	{
		CWindow(GetParent()).SendMessage(PSM_SETWIZBUTTONS, 0, flags);
	}

	void		Unchanged(HWND pageHwnd)
	{
		CWindow(GetParent()).SendMessage(PSM_UNCHANGED, 
			reinterpret_cast<WPARAM>(pageHwnd), 0);
	}

	void	Create(const char *title = NULL);

protected:
	PROPSHEETPAGE	mPSP;

	void	EndPropertyDialog(CComboError error);

private:
	HPROPSHEETPAGE	mPageHandle;

	CComboError	*mPError;
	PGPBoolean	*mPSkipConfirmCancel;

	void	SetVariables(CComboError *pError, PGPBoolean *pSkipConfirmCancel);
	void	HandleWindowError(CComboError error);

	static UINT CALLBACK	PropSheetPageProc(HWND hWnd, UINT uMsg, 
		LPPROPSHEETPAGE pPsp);

protected:
	virtual void	PreCreateHook() { }

	BOOL		OnCommand(PGPUInt16 notifyCode, PGPUInt16 itemId, HWND ctrl);
	void		OnNcDestroy();
	PGPUInt32	OnNotify(PGPUInt16 ctrlId, LPNMHDR pNMHDR);

	virtual PGPBoolean	OnPsnApply(PGPBoolean falseIfApply) {return TRUE;}
	virtual void		OnPsnHelp() { }
	virtual PGPBoolean	OnPsnKillActive() {return FALSE;}
	virtual PGPBoolean	OnPsnQueryCancel() {return FALSE;}
	virtual void		OnPsnReset(PGPBoolean clickedCancel) { }
	virtual PGPInt32	OnPsnSetActive() {return 0;}
	virtual PGPInt32	OnPsnWizBack() {return 0;}
	virtual PGPInt32	OnPsnWizFinish() {return 0;}
	virtual PGPInt32	OnPsnWizNext() {return 0;}

	// The following functions are not implemented.
private:
	PGPInt32	CreateModal(HWND parent);
	void		CreateNonModal(HWND parent);
	void		DestroyDialog();

	void	EndModalDialog(PGPInt32 result);
	void	EndModalDialog(CComboError error);
	void	EndNonModalDialog();
};

_PGP_END

#endif	// ] Included_CPropertyPage_h
